/*
 * Logserver
 * Copyright (C) 2017-2025 Joel Reardon
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef __EXIT_SIGNAL__H__
#define __EXIT_SIGNAL__H__

#include <mutex>

using namespace std;

/* global static class to signal to all threads whether we are shutting down */
class ExitSignal {
public:
	/* returns true if the exit signal is set. if the parameter is true then
	 * it will set the signal to true, otherwise it leaves its existing
	 * value */
	static bool check(bool set) {
		static bool exit_signal = false;
		static mutex m;
		unique_lock<mutex> ul(m);

		if (set) exit_signal = true;
		return exit_signal;
	}
};

#endif // __EXIT_SIGNAL__H__
