/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.util;

import android.databinding.tool.util.L;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class GenerationalClassUtil {
    public static <T extends Serializable> List<T> loadObjects(ClassLoader classLoader, Filter filter) {
        ArrayList result = new ArrayList();
        if (!(classLoader instanceof URLClassLoader)) {
            L.d("class loader is not url class loader (%s). skipping.", classLoader.getClass());
            return result;
        }
        URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
        for (URL url : urlClassLoader.getURLs()) {
            L.d("checking url %s for intermediate data", url);
            try {
                File file = new File(url.toURI());
                if (!file.exists()) {
                    L.d("cannot load file for %s", url);
                    continue;
                }
                if (file.isDirectory()) {
                    GenerationalClassUtil.loadFromDirectory(filter, result, file);
                    continue;
                }
                GenerationalClassUtil.loadFomZipFile(filter, result, file);
            }
            catch (IOException e) {
                L.d("cannot open zip file from %s", url);
            }
            catch (URISyntaxException e) {
                L.d("cannot open zip file from %s", url);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Serializable> void loadFromDirectory(final Filter filter, List<T> result, File directory) {
        Collection<File> files = FileUtils.listFiles(directory, new IOFileFilter(){

            @Override
            public boolean accept(File file) {
                return filter.accept(file.getName());
            }

            @Override
            public boolean accept(File dir, String name) {
                return filter.accept(name);
            }
        }, TrueFileFilter.INSTANCE);
        for (File file : files) {
            FileInputStream inputStream = null;
            try {
                inputStream = FileUtils.openInputStream(file);
                T item = GenerationalClassUtil.fromInputStream(result, inputStream);
                L.d("loaded item %s from file", item);
                if (item == null) continue;
                result.add(item);
            }
            catch (IOException e) {
                L.e(e, "Could not merge in Bindables from %s", file.getAbsolutePath());
            }
            catch (ClassNotFoundException e) {
                L.e(e, "Could not read Binding properties intermediate file. %s", file.getAbsolutePath());
            }
            finally {
                IOUtils.closeQuietly(inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Serializable> void loadFomZipFile(Filter filter, List<T> result, File file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!filter.accept(entry.getName())) continue;
            L.d("loading data from file %s", entry.getName());
            InputStream inputStream = null;
            try {
                inputStream = zipFile.getInputStream(entry);
                T item = GenerationalClassUtil.fromInputStream(result, inputStream);
                L.d("loaded item %s from zip file", item);
                if (item == null) continue;
                result.add(item);
            }
            catch (IOException e) {
                L.e(e, "Could not merge in Bindables from %s", file.getAbsolutePath());
            }
            catch (ClassNotFoundException e) {
                L.e(e, "Could not read Binding properties intermediate file. %s", file.getAbsolutePath());
            }
            finally {
                IOUtils.closeQuietly(inputStream);
            }
        }
    }

    private static <T extends Serializable> T fromInputStream(List<T> result, InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(inputStream);
        return (T)((Serializable)in.readObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeIntermediateFile(ProcessingEnvironment processingEnv, String packageName, String fileName, Serializable object) {
        ObjectOutputStream oos = null;
        try {
            FileObject intermediate = processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, packageName, fileName, new Element[0]);
            OutputStream ios = intermediate.openOutputStream();
            oos = new ObjectOutputStream(ios);
            oos.writeObject(object);
            oos.close();
            L.d("wrote intermediate bindable file %s %s", packageName, fileName);
            IOUtils.closeQuietly(oos);
        }
        catch (IOException e) {
            L.e(e, "Could not write to intermediate file: %s", fileName);
        }
        finally {
            IOUtils.closeQuietly(oos);
        }
    }

    public static class ExtensionFilter
    implements Filter {
        private final String mExtension;

        public ExtensionFilter(String extension) {
            this.mExtension = extension;
        }

        @Override
        public boolean accept(String entryName) {
            return entryName.endsWith(this.mExtension);
        }
    }

    public static interface Filter {
        public boolean accept(String var1);
    }
}

